export type NotificationType = 'system' | 'order' | 'reminder' | 'ai' | 'greeting';
export type NotificationStatus = 'unread' | 'read';
export type DeliveryChannel = 'in_app' | 'push' | 'email' | 'whatsapp';

export interface Notification {
  id: string;
  user_id: string;
  vendor_id?: string;
  type: NotificationType;
  title: string;
  message: string;
  status: NotificationStatus;
  delivery_channel: DeliveryChannel;
  read: boolean;
  sent_at: string;
  created_at: string;
  deleted_at?: string;
}

export interface SendNotificationRequest {
  user_id?: string;
  vendor_id?: string;
  type: NotificationType;
  title: string;
  message: string;
  send_push?: boolean;
} 